#include "chip.h"
#include "string.h"
#include "lcd_12864.h"
#include "systick.h"
#include "usart.h"
#include "led.h"
#include "veml6075.h"
#include "pwm.h"

#define TICKRATE_HZ	10

int main()
{
  uint8_t  LSB,MSB,i,times=30;
	uint16_t txSize=2,rxSize=0,last_Data;
  uint32_t sum_data,avr_data,uva_data,uvb_data;
	int cnt1=0,cnt2=0,flag=0;
	char *res;
	
	SystemCoreClockUpdate();
	SystemInit();
	SysTick_Config(SystemCoreClock/TICKRATE_HZ);
	Chip_GPIO_Init(LPC_GPIO_PORT);
	VEML6075_Init();
	Board_UART0_Init(115200);
	Board_UART1_Init(115200);
	
	LED_Init();
	SCT_PWM_Init();
	LCD12864_Init();
	LCD12864_Clear();
	
	txData[0]=0x00,txData[1]=0x40;
  SetupXferRecAndExecute(I2C_ADDR_7BIT,
	txData,txSize,rxData,rxSize);
	last_Data=0;
	txSize=1,rxSize=2;

	LCD12864_char16x16(0,0,0);
	LCD12864_char16x16(2,0,1);
	LCD12864_char16x16(4,0,2);
	LCD12864_char16x16(6,0,3);
	LCD12864_char16x16(8,0,4);
	LCD12864_char16x16(10,0,5);
	LCD12864_char16x16(12,0,6);
	LCD12864_char8x16(0,2,"donatello1996");
	LCD12864_char8x16(0,4,"UVA");
  LCD12864_char16x16(3,4,7);//ǿ
	LCD12864_char16x16(5,4,8);//
	LCD12864_char8x16(7,4,":");
	
	LCD12864_char8x16(0,6,"UVB");
  LCD12864_char16x16(3,6,7);//ǿ
	LCD12864_char16x16(5,6,8);//
	LCD12864_char8x16(7,6,":");
	/*
	LCD12864_char8x16(0,0,"PWM");
	LCD12864_char8x16(0,4,"PWM");
	LCD12864_char16x16(3,0,9);//ͨ
	LCD12864_char16x16(5,0,10);//
	LCD12864_char8x16(7,0,"1");
	LCD12864_char16x16(8,0,11);//
	LCD12864_char16x16(10,0,12);//
	LCD12864_char16x16(12,0,13);//ֵ
	LCD12864_char8x16(14,0,":");
	/*
	LCD12864_char16x16(3,4,9);//ͨ
	LCD12864_char16x16(5,4,10);//
	LCD12864_char8x16(7,4,"2 ");
	LCD12864_char16x16(8,4,11);//
	LCD12864_char16x16(10,4,12);//
	LCD12864_char16x16(12,4,13);//ֵ
	LCD12864_char8x16(14,4,":");
	*/
	while(1) 
	{					
		sum_data=0;
	 	txData[0]=0x07;
	  for(i=0;i<times;i++)
		{
			//UVAָ
			SetupXferRecAndExecute(I2C_ADDR_7BIT,txData,txSize,rxData,rxSize);

			delay(100);
			LSB=rxData[0];
			MSB=rxData[1];

			last_Data=((MSB<<8)+LSB);
			sum_data+=last_Data;
		}
		avr_data=sum_data/times;
		uva_data=avr_data;
		LCD12864_char8x16(8,4,"     ");
		LCD12864_num(8,4,avr_data);
 		
			
	 	txData[0]=0x09;
    sum_data=0;
		for (i=0;i<times;i++)
		{
			//UVBָ
			SetupXferRecAndExecute(I2C_ADDR_7BIT,txData,txSize,rxData, rxSize);
			delay(100);
			LSB = rxData[0];
			MSB = rxData[1];
			last_Data=((MSB<<8)+LSB);
			sum_data+=last_Data;
		}
		avr_data=sum_data/times;
		uvb_data=avr_data;
		LCD12864_char8x16(8,6,"     ");
		LCD12864_num(8,6,avr_data);
	 	
    cnt1=100-(uva_data/200);
		cnt2=100-(uvb_data/200);
		Chip_SCTPWM_SetDutyCycle(SCT_PWM,1,
		Chip_SCTPWM_PercentageToTicks(SCT_PWM,cnt1));
		Chip_SCTPWM_SetDutyCycle(SCT_PWM,2,
		Chip_SCTPWM_PercentageToTicks(SCT_PWM,cnt2));
		printf("⵽UVAָ%dUVBָ%d\n\n",
		uva_data,uvb_data);
		delay_Long2(2000);
	}
}
