#ifndef __VEML6075_H_
#define __VEML6075_H_
#include "chip.h"

#define BOARD_NXP_LPCXPRESSO_824
I2CM_XFER_T i2cmXferRec;
/* System clock is set to 24MHz, I2C clock is set to 600kHz */
#define I2C_CLK_DIVIDER 40

#define I2C_BITRATE 100000
//IIC10KHz

/* Note: The ROM code requires the address to be between bits [6:0]
         bit 7 is ignored */
#define I2C_ADDR_7BIT 0x10

uint8_t txData[16],rxData[16];

void VEML6075_Init()
{

	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_SWM);
	Chip_SWM_EnableFixedPin(SWM_FIXED_I2C0_SDA);
	Chip_SWM_EnableFixedPin(SWM_FIXED_I2C0_SCL);
	Chip_IOCON_PinSetI2CMode(LPC_IOCON, IOCON_PIO10, PIN_I2CMODE_FASTPLUS);
	Chip_IOCON_PinSetI2CMode(LPC_IOCON, IOCON_PIO11, PIN_I2CMODE_FASTPLUS);
	Chip_Clock_DisablePeriphClock(SYSCTL_CLOCK_SWM);
	Chip_I2C_Init(LPC_I2C);
	Chip_I2C_SetClockDiv(LPC_I2C, I2C_CLK_DIVIDER);
	Chip_I2CM_SetBusSpeed(LPC_I2C, I2C_BITRATE);
	Chip_I2CM_Enable(LPC_I2C);
	//NVIC_DisableIRQ(I2C_IRQn);
	
}

void SetupXferRecAndExecute(uint8_t devAddr,uint8_t *txBuffPtr,uint16_t txSize,
uint8_t *rxBuffPtr,uint16_t rxSize)
{
	i2cmXferRec.slaveAddr = devAddr;
	i2cmXferRec.status = 0;
	i2cmXferRec.txSz = txSize;
	i2cmXferRec.rxSz = rxSize;
	i2cmXferRec.txBuff = txBuffPtr;
	i2cmXferRec.rxBuff = rxBuffPtr;

	Chip_I2CM_XferBlocking(LPC_I2C,&i2cmXferRec);
}


void Set_IIC_Master(uint16_t i2c_addr,uint32_t ledStateOut)
{
	txData[0]=0x16;							
	txData[1]=(uint8_t) ((ledStateOut)     & 0xff);		
	txData[2]=(uint8_t) ((ledStateOut >> 8)  & 0xff);		
	txData[3]=(uint8_t) ((ledStateOut >> 16) & 0xff);		
	txData[4]=(uint8_t) ((ledStateOut >> 24) & 0xff);		
	SetupXferRecAndExecute(i2c_addr,txData,5,rxData,0);
}


#endif
