#ifndef __USART_H_
#define __USART_H_
#include <stdio.h>
#include "chip.h"
#include "string.h"

#define MLIB_UART LPC_USART0
//˴ѡMicro LIBprintf()ָĴں

int fputc(int ch,FILE *f)
{
  Chip_UART_SendBlocking(MLIB_UART,&ch,1);
  return ch;
}

void Board_UART0PutChar(char ch)
{
	Chip_UART_SendBlocking(LPC_USART0,&ch,1);
}

void Board_UART0_PutString(char *str)
{
	int i=0;
	while (str[i]!='\0') 
	{
		Chip_UART_SendBlocking(LPC_USART0,&str[i],1);
		i++;
	}
}

int Board_UART0_GetChar()
{
	uint8_t data;
	if (Chip_UART_Read(LPC_USART0,&data,1)==1) 
	return (int)data;
	return -1;
}

void Board_UART1PutChar(char ch)
{
	Chip_UART_SendBlocking(LPC_USART1,&ch,1);
}

void Board_UART1_PutString(char *str)
{
	while (*str!='\0') 
		Board_UART1PutChar(*str++);
}

int Board_UART1_GetChar()
{
	uint8_t data;
	if (Chip_UART_Read(LPC_USART1,&data,1)==1) 
	return (int)data;
	return -1;
}

void Board_UART0_Init(int baud)
{
	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_SWM);
	Chip_Clock_SetUARTClockDiv(1);
	Chip_SWM_MovablePinAssign(SWM_U0_TXD_O,4);
	Chip_SWM_MovablePinAssign(SWM_U0_RXD_I,0);
	Chip_Clock_DisablePeriphClock(SYSCTL_CLOCK_SWM);
	Chip_UART_Init(LPC_USART0);
	Chip_UART_ConfigData(LPC_USART0, 
	UART_CFG_DATALEN_8|UART_CFG_PARITY_NONE|
	UART_CFG_STOPLEN_1);
	Chip_Clock_SetUSARTNBaseClockRate((baud*16),true);
	Chip_UART_SetBaud(LPC_USART0,baud);
	Chip_UART_Enable(LPC_USART0);
	Chip_UART_TXEnable(LPC_USART0);
}

void Board_UART1_Init(int baud)
{
	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_SWM);
	Chip_Clock_SetUARTClockDiv(1);
	Chip_SWM_MovablePinAssign(SWM_U1_TXD_O,7);
	Chip_SWM_MovablePinAssign(SWM_U1_RXD_I,18);
	Chip_Clock_DisablePeriphClock(SYSCTL_CLOCK_SWM);
	Chip_UART_Init(LPC_USART1);
	Chip_UART_ConfigData(LPC_USART1, 
	UART_CFG_DATALEN_8|UART_CFG_PARITY_NONE|
	UART_CFG_STOPLEN_1);
	Chip_Clock_SetUSARTNBaseClockRate((baud*16),true);
	Chip_UART_SetBaud(LPC_USART1,baud);
	Chip_UART_Enable(LPC_USART1);
	Chip_UART_TXEnable(LPC_USART1);
}

char *Board_itoa(int value,char *result,int base)
{
    char* ptr = result, *ptr1 = result, tmp_char;
    int tmp_value;

    if (base < 2 || base > 36) { *result = '\0'; return result; }
    do {
        tmp_value = value;
        value /= base;
        *ptr++ = "zyxwvutsrqponmlkjihgfedcba9876543210123456789abcdefghijklmnopqrstuvwxyz" [35 + (tmp_value - value * base)];
    } while ( value );

    if (tmp_value < 0) *ptr++ = '-';
    *ptr-- = '\0';
    while (ptr1 < ptr) 
		{
        tmp_char = *ptr;
        *ptr--= *ptr1;
        *ptr1++ = tmp_char;
    }
    return result;
}

#endif
