#ifndef __PWM_H_
#define __PWM_H_
#include "chip.h"

#define SCT_PWM            LPC_SCT
#define SCT_PWM_PIN_OUT    1		/* COUT1 Generate square wave */
#define SCT_PWM_PIN_LED    0		/* COUT0 [index 2] Controls LED */
#define SCT_PWM_OUT        1		/* Index of OUT PWM */
#define SCT_PWM_LED        2		/* Index of LED PWM */
#define SCT_PWM_RATE   10000		/* PWM frequency 10 KHz */

void SCT_PWM_Init()
{
	Chip_SCTPWM_Init(SCT_PWM);
	Chip_SCTPWM_SetRate(SCT_PWM,SCT_PWM_RATE);
	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_SWM);

	Chip_SWM_MovablePinAssign(SWM_SCT_OUT1_O, 12);
	Chip_SWM_MovablePinAssign(SWM_SCT_OUT0_O, 16);


	Chip_Clock_DisablePeriphClock(SYSCTL_CLOCK_SWM);
	Chip_SCTPWM_SetOutPin(SCT_PWM,SCT_PWM_OUT,SCT_PWM_PIN_OUT);
	Chip_SCTPWM_SetOutPin(SCT_PWM,SCT_PWM_LED,SCT_PWM_PIN_LED);

	Chip_SCTPWM_SetDutyCycle(SCT_PWM, SCT_PWM_OUT,Chip_SCTPWM_GetTicksPerCycle(SCT_PWM)/2);
	Chip_SCTPWM_SetDutyCycle(SCT_PWM, SCT_PWM_LED,0);
	Chip_SCTPWM_Start(SCT_PWM);
}

#endif