#ifndef __LED_H_
#define __LED_H_
#include "chip.h"

const uint8_t ledBits[3]={12,16,27};

void LED_Init()
{
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT,0,12);
	Chip_GPIO_SetPinState(LPC_GPIO_PORT,0,12,true);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT,0,16);
	Chip_GPIO_SetPinState(LPC_GPIO_PORT,0,16,true);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT,0,27);
	Chip_GPIO_SetPinState(LPC_GPIO_PORT,0,27,true);
}

void LED_Set(uint8_t LEDNumber, bool On)
{
	Chip_GPIO_SetPinState(LPC_GPIO_PORT,0,
	ledBits[LEDNumber],(bool)!On);
}

bool LED_Test(uint8_t LEDNumber)
{
	bool state=false;
	state=(bool)!Chip_GPIO_GetPinState(LPC_GPIO_PORT,
	0,ledBits[LEDNumber]);
	return state;
}

void LED_Toggle(uint8_t LEDNumber)
{
	Chip_GPIO_SetPinToggle(LPC_GPIO_PORT,
	0,ledBits[LEDNumber]);
}

#endif
