#ifndef __LCD_12864_H_
#define __LCD_12864_H_
#include "chip.h"
#include "eng.h"
#include "chi.h"

#define S_duigou	0X00
#define S_up	0X01
#define S_down	0X02
#define S_left	0X03
#define S_right	0X04
#define S_hcf	0X05
#define S_maohao	0X06

#define SDA_SET     Chip_GPIO_SetPinOutHigh( LPC_GPIO_PORT, 0, 24 )//P1OUT |= BIT0
#define SDA_CLR     Chip_GPIO_SetPinOutLow( LPC_GPIO_PORT, 0, 24 )//P1OUT &= (~BIT0)
#define SDA_DIR     Chip_GPIO_SetPinDIROutput( LPC_GPIO_PORT, 0, 24)

#define SCK_SET     Chip_GPIO_SetPinOutHigh( LPC_GPIO_PORT, 0 ,25 )//P1OUT |= BIT1
#define SCK_CLR     Chip_GPIO_SetPinOutLow( LPC_GPIO_PORT, 0, 25 )//P1OUT &= (~BIT1)
#define SCK_DIR    	Chip_GPIO_SetPinDIROutput( LPC_GPIO_PORT, 0, 25)

#define A0_SET      Chip_GPIO_SetPinOutHigh( LPC_GPIO_PORT, 0, 26 )//P1OUT |= BIT2
#define A0_CLR      Chip_GPIO_SetPinOutLow( LPC_GPIO_PORT, 0, 26 )//P1OUT &= (~BIT2)
#define A0_DIR      Chip_GPIO_SetPinDIROutput( LPC_GPIO_PORT, 0, 26);

#define RST_SET     Chip_GPIO_SetPinOutHigh( LPC_GPIO_PORT, 0, 13 )//P1OUT |= BIT3
#define RST_CLR     Chip_GPIO_SetPinOutLow( LPC_GPIO_PORT, 0 , 13 )// P1OUT &= (~BIT3)
#define RST_DIR     Chip_GPIO_SetPinDIROutput( LPC_GPIO_PORT, 0, 13)

#define CS_SET      Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT,0,17)//P1OUT |= BIT4
#define CS_CLR      Chip_GPIO_SetPinOutLow(LPC_GPIO_PORT,0,17)//P1OUT &= (~BIT4)
#define CS_DIR      Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT,0,17)



void delay(unsigned int n) 
{ 
  while(n!=0){n--;} 
} 

void delay_Long(unsigned long n)
{
  unsigned int i;
  for(i=0;i<n;i++)
  delay(100);
}

void delay_Long2(unsigned long n)
{
  unsigned int i;
  for(i=0;i<n;i++)
  delay(300);
}

void LCD12864_GPIO_Init()
{
	SDA_DIR;
	SCK_DIR;
	A0_DIR;
	RST_DIR;
	CS_DIR;
}

//
void SendByte(unsigned char Dbyte)
{
  unsigned char i,TEMP; 
  TEMP=Dbyte;
  for(i=0;i<8;i++)
  {
    
    if(TEMP&0x80)
    SDA_SET;
    else
    SDA_CLR;
    SCK_CLR;
    SCK_SET;
    TEMP=TEMP<<1;
  }
} 

//д
void LCD12864_Write_Cmd(unsigned char Cbyte)
{
  CS_CLR; 
  A0_CLR;  
  SendByte(Cbyte);
  CS_SET; 
}

//д
void LCD12864_Write_Data(unsigned char Dbyte)
{
  CS_CLR;
  A0_SET;	 	
  SendByte(Dbyte);
  CS_SET; 
}

//ʾӢַ
void LCD12864_char8x16(
unsigned char col,
unsigned char row,
unsigned char *pcStr)
{	
  unsigned char i;
  unsigned int X=0;
  
  while(*pcStr != 0)  
  {
    if(col>15)return;
    if(row>8)return;
    
    X=(*pcStr++ -32)*0x10;
    
    LCD12864_Write_Cmd(0xb0+row);
    LCD12864_Write_Cmd(0x10+(8*col/16));		
    LCD12864_Write_Cmd(0x00+(8*col%16));
    for(i=0;i<8;i++)   
			LCD12864_Write_Data(ENGLISH[X++]);
     
    
    LCD12864_Write_Cmd(0xb1+row);	
    LCD12864_Write_Cmd(0x10+(8*col/16));		
    LCD12864_Write_Cmd(0x00+(8*col%16));
    for(i=0;i<8;i++)
    LCD12864_Write_Data(ENGLISH[X++]); 
    col++;
  }
}

//ʾֵ
void LCD12864_num(unsigned char col,
unsigned char row,unsigned long Num)
{
  unsigned long temp=0;
  unsigned int X=0;
  unsigned char i,BitNum=0;
  if(Num==0)
    LCD12864_char8x16(col,row,"0");
  else
  {
    temp=Num;
    while(temp){temp/=10;BitNum++;}
    temp=1;
    for(i=0;i<(BitNum-1);i++)
      temp*=10;
    
    while(temp!=0)
    {
      if(col>15)return;
      if(row>8)return;
      
	X=(Num/temp+16)*16;
      
	LCD12864_Write_Cmd(0xb0+row);
	LCD12864_Write_Cmd(0x10+(8*col/16));		
	LCD12864_Write_Cmd(0x00+(8*col%16));
	for(i=0;i<8;i++)
		LCD12864_Write_Data(ENGLISH[X++]);
	LCD12864_Write_Cmd(0xb1+row);	
	LCD12864_Write_Cmd(0x10+(8*col/16));		
	LCD12864_Write_Cmd(0x00+(8*col%16));
	for(i=0;i<8;i++)
		LCD12864_Write_Data(ENGLISH[X++]);  
      col++;
      Num%=temp;
      temp/=10;
    }
  }
}

void LCD12864_char16x16(
unsigned char col,unsigned char row,
unsigned char i)
{	
  unsigned int pos=0;
  
    if(col>15||row>8)return;
    
    pos=i*32;
    
    LCD12864_Write_Cmd(0xb0+row);
    LCD12864_Write_Cmd(0x10+(8*col/16));		
    LCD12864_Write_Cmd(0x00+(8*col%16));
//λ
    for(i=0;i<16;i++)
      LCD12864_Write_Data(CHINESE[pos++]);
    
    LCD12864_Write_Cmd(0xb1+row);
    LCD12864_Write_Cmd(0x10+(8*col/16));		
    LCD12864_Write_Cmd(0x00+(8*col%16));
//λ
    for(i=0;i<16;i++)
			LCD12864_Write_Data(CHINESE[pos++]);  
}

//ʾͼƬ
void PUTImage(const unsigned char *pcStr)
{
  unsigned char x,y;
  unsigned int i=0;
  for(y=0;y<8;y++)
  {    
    LCD12864_Write_Cmd(0xb0+y);
    LCD12864_Write_Cmd(0x10);		
    LCD12864_Write_Cmd(0x00);
    for(x=0;x<128;x++)LCD12864_Write_Data(pcStr[i++]); 
  }  
}

void PUTGraph(unsigned char row,unsigned char col,unsigned char num,unsigned char flag)
{	
    unsigned char i;
    unsigned int X=0;      
    if(col > 15)return;
    if(row > 8)return;
		
    X= num*0x20;
		  
    LCD12864_Write_Cmd(0xb0+row);
    LCD12864_Write_Cmd(0x10+(8*col/16));		
    LCD12864_Write_Cmd(0x00+(8*col%16));
    for(i=0;i<16;i++)
    {
      if(flag)LCD12864_Write_Data(~Graph[X++]);
      else LCD12864_Write_Data(Graph[X++]);
    } 
    
    LCD12864_Write_Cmd(0xb1+row);	
    LCD12864_Write_Cmd(0x10+(8*col/16));		
    LCD12864_Write_Cmd(0x00+(8*col%16));
    for(i=0;i<16;i++)
    {
      if(flag)LCD12864_Write_Data(~Graph[X++]);
      else LCD12864_Write_Data(Graph[X++]);
    } 
 }

//
void LCD12864_Clear()
{	 
  unsigned char x,y;
  for(y=0;y<8;y++)
  {    
    LCD12864_Write_Cmd(0xb0+y);
    LCD12864_Write_Cmd(0x10);		
    LCD12864_Write_Cmd(0x00);
    for(x=0;x<128;x++)LCD12864_Write_Data(0); 
  }	
}	 

//ˢ
void LCD12864_Fill()
{	 
  unsigned char x,y;
  for(y=0;y<8;y++)
  {    
    LCD12864_Write_Cmd(0xb0+y);
    LCD12864_Write_Cmd(0x10);		
    LCD12864_Write_Cmd(0x00);
    for(x=0;x<128;x++)LCD12864_Write_Data(0xff); 
  }	
}

//ʼ
void LCD12864_Init()
{	
	LCD12864_GPIO_Init();
	CS_CLR; 
	RST_CLR;
	delay(5000);
	RST_SET;
	delay(5000);	  
	LCD12864_Write_Cmd(0xe2);
	// system reset
	delay(5000);
   LCD12864_Write_Cmd(0x24);
	// SET VLCD RESISTOR RATIO
   LCD12864_Write_Cmd(0xa2);                                                      
	// BR=1/9
   LCD12864_Write_Cmd(0xa0);                                                     
	// set seg direction
   LCD12864_Write_Cmd(0xc8);                                                      
	// set com direction
   LCD12864_Write_Cmd(0x2f);                                                      
	 // set power control
   LCD12864_Write_Cmd(0x40);                                                      
	 // set scroll line
   LCD12864_Write_Cmd(0x81);                                                      
	 // SET ELECTRONIC VOLUME
   LCD12864_Write_Cmd(0x20);
   LCD12864_Write_Cmd(0xa7);                                                      
	 // set inverse display	a6 off, a7 on                                                   
	 // set all pixel on
   LCD12864_Write_Cmd(0xaf);                                                      
	 // set display enable
   LCD12864_Clear();
}

#endif
