#ifndef __CHIP_H_
#define __CHIP_H_

#include "lpc_types.h"
#include "sys_config.h"
#include "cmsis.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef CORE_M0PLUS
#error CORE_M0PLUS is not defined for the LPC8xx architecture
#error CORE_M0PLUS should be defined as part of your compiler define list
#endif

#ifndef CHIP_LPC8XX
#error The LPC8XX Chip include path is used for this build, but
#error CHIP_LPC8XX is not defined!
#endif

/** @defgroup PERIPH_8XX_BASE CHIP: LPC8xx Peripheral addresses and register set declarations
 * @ingroup CHIP_8XX_Drivers
 * @{
 */

/* Base addresses */
#define LPC_FLASH_BASE        (0x00000000UL)
#define LPC_RAM_BASE          (0x10000000UL)
#define LPC_ROM_BASE          (0x1FFF0000UL)
#define LPC_APB0_BASE         (0x40000000UL)
#define LPC_AHB_BASE          (0x50000000UL)

/* APB0 peripherals */
#define LPC_WWDT_BASE         (0x40000000UL)
#define LPC_MRT_BASE          (0x40004000UL)
#define LPC_WKT_BASE          (0x40008000UL)
#define LPC_SWM_BASE          (0x4000C000UL)
#define LPC_ADC_BASE          (0x4001C000UL)  /* Available only on LPC82x */
#define LPC_PMU_BASE          (0x40020000UL)
#define LPC_CMP_BASE          (0x40024000UL)
#define LPC_DMATIRGMUX_BASE   (0x40028000UL)  /* Available only on LPC82x */
#define LPC_INMUX_BASE        (0x4002C000UL)  /* Available only on LPC82x */

#define LPC_FMC_BASE          (0x40040000UL)
#define LPC_IOCON_BASE        (0x40044000UL)
#define LPC_SYSCTL_BASE       (0x40048000UL)
#define LPC_I2C0_BASE         (0x40050000UL)
#define LPC_I2C1_BASE         (0x40054000UL)  /* Available only on LPC82x */
#define LPC_SPI0_BASE         (0x40058000UL)
#define LPC_SPI1_BASE         (0x4005C000UL)
#define LPC_USART0_BASE       (0x40064000UL)
#define LPC_USART1_BASE       (0x40068000UL)
#define LPC_USART2_BASE       (0x4006C000UL)
#define LPC_I2C2_BASE         (0x40070000UL)  /* Available only on LPC82x */
#define LPC_I2C3_BASE         (0x40074000UL)  /* Available only on LPC82x */

/* AHB peripherals */
#define LPC_CRC_BASE          (0x50000000UL)
#define LPC_SCT_BASE          (0x50004000UL)
#define LPC_DMA_BASE          (0x50008000UL)  /* Available only on LPC82x */

#define LPC_GPIO_PORT_BASE    (0xA0000000UL)
#define LPC_PIN_INT_BASE      (0xA0004000UL)

#define LPC_WWDT            ((LPC_WWDT_T     *) LPC_WWDT_BASE)
#define LPC_SPI0            ((LPC_SPI_T      *) LPC_SPI0_BASE)
#define LPC_SPI1            ((LPC_SPI_T      *) LPC_SPI1_BASE)
#define LPC_USART0          ((LPC_USART_T    *) LPC_USART0_BASE)
#define LPC_USART1          ((LPC_USART_T    *) LPC_USART1_BASE)
#define LPC_USART2          ((LPC_USART_T    *) LPC_USART2_BASE)
#define LPC_WKT             ((LPC_WKT_T         *) LPC_WKT_BASE)
#define LPC_PMU             ((LPC_PMU_T         *) LPC_PMU_BASE)
#define LPC_CRC             ((LPC_CRC_T         *) LPC_CRC_BASE)
#define LPC_SCT             ((LPC_SCT_T         *) LPC_SCT_BASE)
#define LPC_GPIO_PORT       ((LPC_GPIO_T        *) LPC_GPIO_PORT_BASE)
#define LPC_PININT          ((LPC_PIN_INT_T     *) LPC_PIN_INT_BASE)
#define LPC_IOCON           ((LPC_IOCON_T       *) LPC_IOCON_BASE)
#define LPC_SWM             ((LPC_SWM_T         *) LPC_SWM_BASE)
#define LPC_SYSCTL          ((LPC_SYSCTL_T      *) LPC_SYSCTL_BASE)
#define LPC_CMP             ((LPC_CMP_T         *) LPC_CMP_BASE)
#define LPC_FMC             ((LPC_FMC_T         *) LPC_FMC_BASE)
#define LPC_MRT             ((LPC_MRT_T         *) LPC_MRT_BASE)
#define LPC_I2C0            ((LPC_I2C_T         *) LPC_I2C0_BASE)

#ifdef CHIP_LPC82X
/* Peripherals available only on LPC82x */
#define LPC_ADC             ((LPC_ADC_T         *) LPC_ADC_BASE)
#define LPC_I2C1            ((LPC_I2C_T         *) LPC_I2C1_BASE)
#define LPC_I2C2            ((LPC_I2C_T         *) LPC_I2C2_BASE)
#define LPC_I2C3            ((LPC_I2C_T         *) LPC_I2C3_BASE)
#define LPC_DMA             ((LPC_DMA_T         *) LPC_DMA_BASE)
#define LPC_DMATRIGMUX      ((LPC_DMATRIGMUX_T  *) LPC_DMATIRGMUX_BASE)
#define LPC_INMUX           ((LPC_INMUX_T       *) LPC_INMUX_BASE)
#endif

#define LPC_I2C_BASE         LPC_I2C0_BASE
#define LPC_I2C              LPC_I2C0
#define LPC_SYSCON           LPC_SYSCTL

#ifdef CHIP_LPC82X
#define I2C_IRQHandler       I2C0_IRQHandler
#define PININT0_IRQHandler   PIN_INT0_IRQHandler
#define PININT1_IRQHandler   PIN_INT1_IRQHandler
#define PININT2_IRQHandler   PIN_INT2_IRQHandler
#define PININT3_IRQHandler   PIN_INT3_IRQHandler
#define PININT4_IRQHandler   PIN_INT4_IRQHandler
#define PININT5_IRQHandler   PIN_INT5_IRQHandler
#define PININT6_IRQHandler   PIN_INT6_IRQHandler
#define PININT7_IRQHandler   PIN_INT7_IRQHandler
#endif

extern const uint32_t OscRateIn;

extern const uint32_t ExtRateIn;


#include "romapi_8xx.h"
#include "syscon_8xx.h"
#include "clock_8xx.h"
#include "iocon_8xx.h"
#include "swm_8xx.h"
#include "fmc_8xx.h"
#include "pinint_8xx.h"
#include "pmu_8xx.h"
#include "acmp_8xx.h"
#include "crc_8xx.h"
#include "gpio_8xx.h"
#include "mrt_8xx.h"
#include "uart_8xx.h"
#include "wkt_8xx.h"
#include "wwdt_8xx.h"
#include "sct_8xx.h"
#include "sct_pwm_8xx.h"
#include "spi_8xx.h"
#include "i2cm_8xx.h"
#include "i2cs_8xx.h"
#include "spim_8xx.h"
#include "spis_8xx.h"
#include "irc_8xx.h"
#ifdef CHIP_LPC82X
#include "adc_8xx.h"
#include "dma_8xx.h"
#include "inmux_8xx.h"
#endif

extern uint32_t SystemCoreClock;

void SystemCoreClockUpdate(void);

void Chip_SystemInit(void);

void Chip_SetupXtalClocking(void);

void Chip_SetupIrcClocking(void);

#ifdef __cplusplus
}
#endif

#endif
