#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "DS18B20.h"
#define READBUFFERSIZE (16)

#define ON 0
#define OFF 1


Serial pc(SERIAL_TX, SERIAL_RX,115200);
Serial wifi_serial(D8, D2,115200);  //wifi;
//DigitalOut myled(LED1);

PwmOut mypwm(LED1);

DigitalOut mylight(PC_5,1);
DigitalOut window(PC_6,1);

DigitalInOut sensor(PC_11);     // sensor connected to pin 5

// an SPI sub-class that provides a constructed default
class SPIPreInit : public SPI
{
public:
    SPIPreInit(PinName mosi, PinName miso, PinName clk) : SPI(mosi,miso,clk) {
        format(8,3);
        frequency(2000000);
    };
};
SPIPreInit gSpi(PB_5,NC,PB_3);//SPI_SCK= PB_13, SPI_MOSI= PB_15,
Adafruit_SSD1306_Spi gOled1(gSpi,PB_1,PB_14,PB_2);//spi  DC(PB_1)   RST(PB_14)   CS(PB_2)<--->


float gHome_Temperature;
void Serial_Receive_Callback()
{
    char buffer[32];
    wifi_serial.gets(buffer,13);
    pc.printf("I heard %s\n",buffer);

    if(buffer[0]=='F' && buffer[1]=='F') {
        if(buffer[3]=='1') {
            if(buffer[5]=='1') {
                gOled1.setTextCursor(38,32);
                gOled1.printf("Light ON       ");
                mylight=ON;
            } else {
                gOled1.setTextCursor(38,32);
                gOled1.printf("Light OFF      ");
                mylight=OFF;
            }
        }
        if(buffer[3]=='2') {
            if(buffer[5]=='1') {
                gOled1.setTextCursor(38,32);
                gOled1.printf("Window ON      ");
                window=ON;
            } else {
                window=OFF;
                gOled1.setTextCursor(38,32);
                gOled1.printf("Window OFF     ");
            }
        }
        if(buffer[3]=='6') {
            if(buffer[5]=='1') {
                gOled1.setTextCursor(38,32);
                gOled1.printf("Desk Lamp %d   %",buffer[6]);
                mypwm.pulsewidth_us(buffer[6]*10);
            } else {
                gOled1.setTextCursor(38,32);
                gOled1.printf("Desk Lamp OFF  ");
                mypwm.pulsewidth_us(0);
            }
        }
        if(buffer[3]=='7') {
            if(buffer[5]=='1') {
                gOled1.setTextCursor(38,32);
                gOled1.printf("Conditioner %dC",buffer[6]);
            } else
                gOled1.printf("Conditioner OFF" );
        }

    }
    gOled1.display();
}
int main()
{
    int i = 1;

    wifi_serial.attach(&Serial_Receive_Callback);
    mypwm.period_ms(1);
    mypwm.pulsewidth_us(0);

    gOled1.setTextSize(1);
    gOled1.printf(" Voice Control System");
    gOled1.drawLine(0, 10, 128,10, 1);
    gOled1.setTextCursor(2,16);
    gOled1.printf("Temp:");
    gOled1.setTextCursor(2,32);
    gOled1.printf("Order:");
    gOled1.display();

    sensor.mode(PullUp);

    while(1) {
        wait(1);
        //pc.printf(szLineString);//
        //wifi_serial.printf("This program runs since %d seconds.\n", i);
        //gOled1.setTextCursor(40,32);
        //gOled1.printf("%u\r",i);
        //gOled1.printf(szLineString);
        gHome_Temperature=DS18B20_Temperature();
        gOled1.setTextCursor(36,16);
        gOled1.printf("%2.1fC",gHome_Temperature);

        gOled1.display();
    }
}
