#include "mbed.h"
 
AnalogIn analog_value(A0);
AnalogIn analog_value_1(A1);
DigitalInOut DHT_11(PA_6);
DigitalOut led(LED1);
Serial pc(SERIAL_TX, SERIAL_RX);

uint8_t  U8T_data_H,U8T_data_L,U8RH_data_H,U8RH_data_L,U8checkdata;  
uint8_t  U8T_data_H_temp,U8T_data_L_temp,U8RH_data_H_temp,U8RH_data_L_temp,U8checkdata_temp;

static uint8_t DHT11_read_byte(void)  
{       
    uint8_t i;    
    uint8_t data = 0;      
                         
    for(i = 0; i < 8; i++)         
    {      
        data <<= 1;          
           while((!DHT_11));  
        wait(0.00003);   
  
        if(DHT_11)   
					{  
            data |= 0x1;  
            while(DHT_11);  
					}  
     }  
                           
     return data;  
}  
    
static uint8_t DHT11_start_sampling(void)  
{  
    DHT_11 = 0;  
    wait(0.018);  
    DHT_11 = 1;  

    wait(0.00002);    

    DHT_11 = 1;  
    if(!DHT_11)               
    {  
       while((!DHT_11));  
 
       while((DHT_11));  
       return 1;  
    }  
    return 0;                 
}  
  
void DHT11_get_data(void)  
{        
    uint8_t temp; 
	
    if(DHT11_start_sampling())
			{  
        U8RH_data_H_temp = DHT11_read_byte();  
        U8RH_data_L_temp = DHT11_read_byte();  
        U8T_data_H_temp     = DHT11_read_byte();  
        U8T_data_L_temp     = DHT11_read_byte();  
        U8checkdata_temp = DHT11_read_byte();  
    
        DHT_11 = 1;  

        temp=(U8T_data_H_temp+U8T_data_L_temp+U8RH_data_H_temp+U8RH_data_L_temp);  
        if(temp==U8checkdata_temp)  
        {  
            U8RH_data_H=U8RH_data_H_temp;  
            U8RH_data_L=U8RH_data_L_temp;  
            U8T_data_H=U8T_data_H_temp;  
            U8T_data_L=U8T_data_L_temp;  
            U8checkdata=U8checkdata_temp;  
				}
    }  
}  
  
void DTH11_test()  
{  
    while(1)  
    {  
        DHT11_get_data();  
        wait(1);      
    }  
}  

int main() 
{
		char a='%';
    float meas_1, meas_2;
    
    printf("\nAnalogIn example\n");
    
    while(1) 
		{
        meas_1 = analog_value.read(); 
        meas_1 = meas_1 * 3300; 
				meas_2 = analog_value_1.read(); 
        meas_2 = meas_1 * 3300; 
				
				pc.printf("T=%d.%dC  H=%d.%d%c   \n",U8T_data_H,U8T_data_L,U8RH_data_H,U8RH_data_L,a);
				pc.printf("AIR=%.3fV  RAY=%.3fV   \n",meas_1,meas_2);
		
				if(meas_1>=3000)
				{
					pc.printf("AIR IS TERRBLE   \n");
				}
				else
				{
					pc.printf ("AIR IS RIGHT   \n");
				}
				
				if(meas_2>=3000)
				{
					pc.printf("RAY IS DARK   \n");
				}
				else if(meas_2>1000 && meas_2 <=2000)
				{
					pc.printf("RAY IS FIT   \n");
				}
				else if(meas_2>=0&& meas_2<=1000)
				{
					pc.printf("RAY IS STRONG   \n");
				}
        wait(0.2); // 200 ms
    }
}
