/**
  ******************************************************************************
  * @file    bsp_SysTick.c
  * @author  fire
  * @version V1.0
  * @date    2013-xx-xx
  * @brief   SysTick ϵͳδʱ10usжϺ,жʱã
  *          õ 1us 10us 1ms жϡ     
  ******************************************************************************
  * @attention
  *
  * ʵƽ̨:Ұ iSO STM32  
  * ̳    :http://www.chuxue123.com
  * Ա    :http://firestm32.taobao.com
  *
  ******************************************************************************
  */
  
	
#include "bsp_SysTick.h"


static __IO u32 TimingDelay = 0;
 
 
/**
  * @brief  ϵͳδʱ SysTick
  * @param  
  * @retval 
  */
void SysTick_Init( void )
{
	/* SystemFrequency / 1000    1msжһ
	 * SystemFrequency / 100000	 10usжһ
	 * SystemFrequency / 1000000 1usжһ
	 */
	if ( SysTick_Config ( SystemCoreClock / 1000000 ) )	// ST3.5.0汾
	{ 
		/* Capture error */ 
		while (1);
	}
	
	// رյδʱ  
	SysTick->CTRL &= ~ SysTick_CTRL_ENABLE_Msk;
	
}


/**
  * @brief   usʱ,1usΪһλ
  * @param  
  *		@arg nTime: Delay_us( 1 ) ʵֵʱΪ 1 * 1us = 1us
  * @retval  
  */
void Delay_us ( __IO u32 nTime )
{ 
	TimingDelay = nTime;	

	// ʹܵδʱ  
	SysTick->CTRL |=  SysTick_CTRL_ENABLE_Msk;

	while( TimingDelay != 0 );
	
	// رյδʱ  
	SysTick->CTRL &= ~ SysTick_CTRL_ENABLE_Msk;	
	
}

/**
  * @brief  ȡĳ
  * @param  
  * @retval 
  * @attention   SysTick жϺ SysTick_Handler()
  */
void TimingDelay_Decrement(void)
{
	if ( TimingDelay != 0x00 )
	{ 
		TimingDelay --;
	}
	
}


/*********************************************END OF FILE**********************/
