#include "rc522_function.h"
#include "rc522_config.h"
#include "stm32f10x.h"
#include "bsp_SysTick.h"


#define   macRC522_DELAY()  Delay_us ( 200 )



/*
 * SPI_RC522_SendByte
 *   RC5221 Byte 
 *   byteҪ͵
 *   : 
 *   ڲ
 */
void SPI_RC522_SendByte ( u8 byte )
{
    u8 counter;
	
	
    for(counter=0;counter<8;counter++)
    {     
			if ( byte & 0x80 )
					macRC522_MOSI_1 ();
			else 
					macRC522_MOSI_0 ();

//			Delay_us ( 3 );
			macRC522_DELAY();
		
			macRC522_SCK_0 ();

//			Delay_us ( 1 );
//			Delay_us ( 3 );
			macRC522_DELAY();
			 
			macRC522_SCK_1();

//			Delay_us ( 3 );
			macRC522_DELAY();
			 
			byte <<= 1; 
			
    } 
	
}


/*
 * SPI_RC522_ReadByte
 *   RC522ȡ1 Byte 
 *   
 *   : RC522ص
 *   ڲ
 */
u8 SPI_RC522_ReadByte ( void )
{
	u8 counter;
	u8 SPI_Data;


	for(counter=0;counter<8;counter++)
	{
			SPI_Data <<= 1;
	 
			macRC522_SCK_0 ();

//			Delay_us ( 3 );
		macRC522_DELAY();
		
			if ( macRC522_MISO_GET() == 1)
					SPI_Data |= 0x01;

//			Delay_us ( 2 );
//			Delay_us ( 3 );
			macRC522_DELAY();

			macRC522_SCK_1 ();
	
//			Delay_us ( 3 );
			macRC522_DELAY();
			
	}
	
	return SPI_Data;
	
}


/*
 * ReadRawRC
 *   RC522Ĵ
 *   ucAddressĴַ
 *   : Ĵĵǰֵ
 *   ڲ
 */
u8 ReadRawRC ( u8 ucAddress )
{
	u8 ucAddr, ucReturn;
	
	
	ucAddr = ( ( ucAddress << 1 ) & 0x7E ) | 0x80;
	
	macRC522_CS_Enable();
	
	SPI_RC522_SendByte ( ucAddr );
	
	ucReturn = SPI_RC522_ReadByte ();
	
	macRC522_CS_Disable();
		
	return ucReturn;
	
}


/*
 * WriteRawRC
 *   дRC522Ĵ
 *   ucAddressĴַ
 *         ucValueдĴֵ
 *   : 
 *   ڲ
 */
void WriteRawRC ( u8 ucAddress, u8 ucValue )
{  
	u8 ucAddr;
	
	
	ucAddr = ( ucAddress << 1 ) & 0x7E;
	
	macRC522_CS_Enable();
	
	SPI_RC522_SendByte ( ucAddr );
	
	SPI_RC522_SendByte ( ucValue );
	
	macRC522_CS_Disable();	

	
}


/*
 * SetBitMask
 *   RC522Ĵλ
 *   ucRegĴַ
 *         ucMaskλֵ
 *   : 
 *   ڲ
 */
void SetBitMask ( u8 ucReg, u8 ucMask )  
{
    u8 ucTemp;
	
	
    ucTemp = ReadRawRC ( ucReg );
	
    WriteRawRC ( ucReg, ucTemp | ucMask );         // set bit mask
	
	
}


/*
 * ClearBitMask
 *   RC522Ĵλ
 *   ucRegĴַ
 *         ucMaskλֵ
 *   : 
 *   ڲ
 */
void ClearBitMask ( u8 ucReg, u8 ucMask )  
{
    u8 ucTemp;
	
	
    ucTemp = ReadRawRC ( ucReg );
	
    WriteRawRC ( ucReg, ucTemp & ( ~ ucMask) );  // clear bit mask
	
	
}


/*
 * PcdAntennaOn
 *    
 *   
 *   : 
 *   ڲ
 */
void PcdAntennaOn ( void )
{
    u8 uc;
	
	
    uc = ReadRawRC ( TxControlReg );
	
    if ( ! ( uc & 0x03 ) )
			SetBitMask(TxControlReg, 0x03);
		
}


/*
 * PcdAntennaOff
 *    
 *   
 *   : 
 *   ڲ
 */
void PcdAntennaOff ( void )
{
  ClearBitMask ( TxControlReg, 0x03 );
		
}


/*
 * PcdRese
 *   λRC522 
 *   
 *   : 
 *   ⲿ
 */
void PcdReset ( void )
{
	macRC522_Reset_Disable();
	
	Delay_us ( 1 );
	
	macRC522_Reset_Enable();
	
	Delay_us ( 1 );
	
	macRC522_Reset_Disable();
	
	Delay_us ( 1 );
	
	WriteRawRC ( CommandReg, 0x0f );
	
	while ( ReadRawRC ( CommandReg ) & 0x10 );
	
	Delay_us ( 1 );
	
  WriteRawRC ( ModeReg, 0x3D );            //巢ͺͽճģʽ MifareͨѶCRCʼֵ0x6363
	
  WriteRawRC ( TReloadRegL, 30 );          //16λʱλ    
	WriteRawRC ( TReloadRegH, 0 );			     //16λʱλ
	
  WriteRawRC ( TModeReg, 0x8D );				   //ڲʱ
	
  WriteRawRC ( TPrescalerReg, 0x3E );			 //öʱƵϵ
	
	WriteRawRC ( TxAutoReg, 0x40 );				   //ƷźΪ100%ASK	
	

}


/*
 * M500PcdConfigISOType
 *   RC522Ĺʽ
 *   ucTypeʽ
 *   : 
 *   ⲿ
 */
void M500PcdConfigISOType ( u8 ucType )
{
	if ( ucType == 'A')                     //ISO14443_A
  {
		ClearBitMask ( Status2Reg, 0x08 );
		
    WriteRawRC ( ModeReg, 0x3D );//3F
		
		WriteRawRC ( RxSelReg, 0x86 );//84
		
		WriteRawRC( RFCfgReg, 0x7F );   //4F
		
		WriteRawRC( TReloadRegL, 30 );//tmoLength);// TReloadVal = 'h6a =tmoLength(dec) 
		
		WriteRawRC ( TReloadRegH, 0 );
		
		WriteRawRC ( TModeReg, 0x8D );
		
		WriteRawRC ( TPrescalerReg, 0x3E );
		
		Delay_us ( 2 );
		
		PcdAntennaOn ();//
		
   }

	 
}


/*
 * PcdComMF522
 *   ͨRC522ISO14443ͨѶ
 *   ucCommandRC522
 *         pInDataͨRC522͵Ƭ
 *         ucInLenByteݵֽڳ
 *         pOutDataյĿƬ
 *         pOutLenBitݵλ
 *   : ״ֵ̬
 *         = MI_OKɹ
 *   ڲ
 */
char PcdComMF522 ( u8 ucCommand, u8 * pInData, u8 ucInLenByte, u8 * pOutData, u32 * pOutLenBit )		
{
    char cStatus = MI_ERR;
    u8 ucIrqEn   = 0x00;
    u8 ucWaitFor = 0x00;
    u8 ucLastBits;
    u8 ucN;
    u32 ul;
	
	
    switch ( ucCommand )
    {
       case PCD_AUTHENT:		//Mifare֤
          ucIrqEn   = 0x12;		//жErrIEn  жIdleIEn
          ucWaitFor = 0x10;		//֤Ѱȴʱ ѯжϱ־λ
          break;
			 
       case PCD_TRANSCEIVE:		//շ ͽ
          ucIrqEn   = 0x77;		//TxIEn RxIEn IdleIEn LoAlertIEn ErrIEn TimerIEn
          ucWaitFor = 0x30;		//Ѱȴʱ ѯжϱ־λ жϱ־λ
          break;
			 
       default:
         break;
			 
    }
   
    WriteRawRC ( ComIEnReg, ucIrqEn | 0x80 );		//IRqInvλܽIRQStatus1RegIRqλֵ෴ 
    ClearBitMask ( ComIrqReg, 0x80 );			//Set1λʱCommIRqRegλ
    WriteRawRC ( CommandReg, PCD_IDLE );		//д
    SetBitMask ( FIFOLevelReg, 0x80 );			//λFlushBufferڲFIFOĶдָԼErrRegBufferOvfl־λ
    
    for ( ul = 0; ul < ucInLenByte; ul ++ )
		  WriteRawRC ( FIFODataReg, pInData [ ul ] );    		//дݽFIFOdata
			
    WriteRawRC ( CommandReg, ucCommand );					//д
   
    
    if ( ucCommand == PCD_TRANSCEIVE )
			SetBitMask(BitFramingReg,0x80);  				//StartSendλݷ λշʹʱЧ
    
    ul = 1000;//ʱƵʵM1ȴʱ25ms
		
    do 														//֤ Ѱȴʱ	
    {
         ucN = ReadRawRC ( ComIrqReg );							//ѯ¼ж
         ul --;
    } while ( ( ul != 0 ) && ( ! ( ucN & 0x01 ) ) && ( ! ( ucN & ucWaitFor ) ) );		//˳i=0,ʱжϣд
		
    ClearBitMask ( BitFramingReg, 0x80 );					//StartSendλ
		
    if ( ul != 0 )
    {
			if ( ! ( ReadRawRC ( ErrorReg ) & 0x1B ) )			//־ĴBufferOfI CollErr ParityErr ProtocolErr
			{
				cStatus = MI_OK;
				
				if ( ucN & ucIrqEn & 0x01 )					//Ƿʱж
				  cStatus = MI_NOTAGERR;   
					
				if ( ucCommand == PCD_TRANSCEIVE )
				{
					ucN = ReadRawRC ( FIFOLevelReg );			//FIFOбֽ
					
					ucLastBits = ReadRawRC ( ControlReg ) & 0x07;	//յֽڵЧλ
					
					if ( ucLastBits )
						* pOutLenBit = ( ucN - 1 ) * 8 + ucLastBits;   	//Nֽȥ1һֽڣ+һλλ ȡλ
					else
						* pOutLenBit = ucN * 8;   					//յֽֽЧ
					
					if ( ucN == 0 )		
            ucN = 1;    
					
					if ( ucN > MAXRLEN )
						ucN = MAXRLEN;   
					
					for ( ul = 0; ul < ucN; ul ++ )
					  pOutData [ ul ] = ReadRawRC ( FIFODataReg );   
					
					}
					
      }
			
			else
				cStatus = MI_ERR;   
			
    }
   
   SetBitMask ( ControlReg, 0x80 );           // stop timer now
   WriteRawRC ( CommandReg, PCD_IDLE ); 
		 
		
   return cStatus;
		
		
}


/*
 * PcdRequest
 *   Ѱ
 *   ucReq_codeѰʽ
 *                     = 0x52ѰӦз14443A׼Ŀ
 *                     = 0x26Ѱδ״̬Ŀ
 *         pTagTypeƬʹ
 *                   = 0x4400Mifare_UltraLight
 *                   = 0x0400Mifare_One(S50)
 *                   = 0x0200Mifare_One(S70)
 *                   = 0x0800Mifare_Pro(X))
 *                   = 0x4403Mifare_DESFire
 *   : ״ֵ̬
 *         = MI_OKɹ
 *   ⲿ
 */
char PcdRequest ( u8 ucReq_code, u8 * pTagType )
{
   char cStatus;  
	 u8 ucComMF522Buf [ MAXRLEN ]; 
   u32 ulLen;
	

   ClearBitMask ( Status2Reg, 0x08 );	//ָʾMIFARECyptolԪͨԼпͨűܵ
   WriteRawRC ( BitFramingReg, 0x07 );	//	͵һֽڵ λ
   SetBitMask ( TxControlReg, 0x03 );	//TX1,TX2ܽŵźŴݾ͵Ƶ13.56زź

   ucComMF522Buf [ 0 ] = ucReq_code;		// Ƭ

   cStatus = PcdComMF522 ( PCD_TRANSCEIVE,	ucComMF522Buf, 1, ucComMF522Buf, & ulLen );	//Ѱ  
  
   if ( ( cStatus == MI_OK ) && ( ulLen == 0x10 ) )	//Ѱɹؿ 
   {    
       * pTagType = ucComMF522Buf [ 0 ];
       * ( pTagType + 1 ) = ucComMF522Buf [ 1 ];
   }
	 
   else
     cStatus = MI_ERR;

   
   return cStatus;
	 
	 
}


/*
 * PcdAnticoll
 *   ײ
 *   pSnrƬкţ4ֽ
 *   : ״ֵ̬
 *         = MI_OKɹ
 *   ⲿ
 */
char PcdAnticoll ( u8 * pSnr )
{
    char cStatus;
    u8 uc, ucSnr_check = 0;
    u8 ucComMF522Buf [ MAXRLEN ]; 
	  u32 ulLen;
    

    ClearBitMask ( Status2Reg, 0x08 );		//MFCryptol Onλ ֻгɹִMFAuthent󣬸λλ
    WriteRawRC ( BitFramingReg, 0x00);		//Ĵ ֹͣշ
    ClearBitMask ( CollReg, 0x80 );			//ValuesAfterCollнյλڳͻ
   
    ucComMF522Buf [ 0 ] = 0x93;	//Ƭͻ
    ucComMF522Buf [ 1 ] = 0x20;
   
    cStatus = PcdComMF522 ( PCD_TRANSCEIVE, ucComMF522Buf, 2, ucComMF522Buf, & ulLen);//뿨Ƭͨ
	
    if ( cStatus == MI_OK)		//ͨųɹ
    {
			for ( uc = 0; uc < 4; uc ++ )
			{
         * ( pSnr + uc )  = ucComMF522Buf [ uc ];			//UID
         ucSnr_check ^= ucComMF522Buf [ uc ];
      }
			
      if ( ucSnr_check != ucComMF522Buf [ uc ] )
				cStatus = MI_ERR;    
				 
    }
    
    SetBitMask ( CollReg, 0x80 );
		
		
    return cStatus;
		
		
}


/*
 * CalulateCRC
 *   RC522CRC16
 *   pIndataCRC16
 *         ucLenCRC16ֽڳ
 *         pOutDatażŵ׵ַ
 *   : 
 *   ڲ
 */
void CalulateCRC ( u8 * pIndata, u8 ucLen, u8 * pOutData )
{
    u8 uc, ucN;
	
	
    ClearBitMask(DivIrqReg,0x04);
	
    WriteRawRC(CommandReg,PCD_IDLE);
	
    SetBitMask(FIFOLevelReg,0x80);
	
    for ( uc = 0; uc < ucLen; uc ++)
	    WriteRawRC ( FIFODataReg, * ( pIndata + uc ) );   

    WriteRawRC ( CommandReg, PCD_CALCCRC );
	
    uc = 0xFF;
	
    do 
    {
        ucN = ReadRawRC ( DivIrqReg );
        uc --;
    } while ( ( uc != 0 ) && ! ( ucN & 0x04 ) );
		
    pOutData [ 0 ] = ReadRawRC ( CRCResultRegL );
    pOutData [ 1 ] = ReadRawRC ( CRCResultRegM );
		
		
}


/*
 * PcdSelect
 *   ѡƬ
 *   pSnrƬкţ4ֽ
 *   : ״ֵ̬
 *         = MI_OKɹ
 *   ⲿ
 */
char PcdSelect ( u8 * pSnr )
{
    char ucN;
    u8 uc;
	  u8 ucComMF522Buf [ MAXRLEN ]; 
    u32  ulLen;
    
    
    ucComMF522Buf [ 0 ] = PICC_ANTICOLL1;
    ucComMF522Buf [ 1 ] = 0x70;
    ucComMF522Buf [ 6 ] = 0;
	
    for ( uc = 0; uc < 4; uc ++ )
    {
    	ucComMF522Buf [ uc + 2 ] = * ( pSnr + uc );
    	ucComMF522Buf [ 6 ] ^= * ( pSnr + uc );
    }
		
    CalulateCRC ( ucComMF522Buf, 7, & ucComMF522Buf [ 7 ] );
  
    ClearBitMask ( Status2Reg, 0x08 );

    ucN = PcdComMF522 ( PCD_TRANSCEIVE, ucComMF522Buf, 9, ucComMF522Buf, & ulLen );
    
    if ( ( ucN == MI_OK ) && ( ulLen == 0x18 ) )
      ucN = MI_OK;  
    else
      ucN = MI_ERR;    

		
    return ucN;
		
		
}


/*
 * PcdAuthState
 *   ֤Ƭ
 *   ucAuth_mode֤ģʽ
 *                     = 0x60֤AԿ
 *                     = 0x61֤BԿ
 *         u8 ucAddrַ
 *         pKey
 *         pSnrƬкţ4ֽ
 *   : ״ֵ̬
 *         = MI_OKɹ
 *   ⲿ
 */
char PcdAuthState ( u8 ucAuth_mode, u8 ucAddr, u8 * pKey, u8 * pSnr )
{
    char cStatus;
	  u8 uc, ucComMF522Buf [ MAXRLEN ];
    u32 ulLen;
    
	
    ucComMF522Buf [ 0 ] = ucAuth_mode;
    ucComMF522Buf [ 1 ] = ucAddr;
	
    for ( uc = 0; uc < 6; uc ++ )
	    ucComMF522Buf [ uc + 2 ] = * ( pKey + uc );   
	
    for ( uc = 0; uc < 6; uc ++ )
	    ucComMF522Buf [ uc + 8 ] = * ( pSnr + uc );   

    cStatus = PcdComMF522 ( PCD_AUTHENT, ucComMF522Buf, 12, ucComMF522Buf, & ulLen );
	
    if ( ( cStatus != MI_OK ) || ( ! ( ReadRawRC ( Status2Reg ) & 0x08 ) ) )
      cStatus = MI_ERR;   
    
		
    return cStatus;
		
		
}


/*
 * PcdWrite
 *   дݵM1һ
 *   u8 ucAddrַ
 *         pDataдݣ16ֽ
 *   : ״ֵ̬
 *         = MI_OKɹ
 *   ⲿ
 */
char PcdWrite ( u8 ucAddr, u8 * pData )
{
    char cStatus;
	  u8 uc, ucComMF522Buf [ MAXRLEN ];
    u32 ulLen;
     
    
    ucComMF522Buf [ 0 ] = PICC_WRITE;
    ucComMF522Buf [ 1 ] = ucAddr;
	
    CalulateCRC ( ucComMF522Buf, 2, & ucComMF522Buf [ 2 ] );
 
    cStatus = PcdComMF522 ( PCD_TRANSCEIVE, ucComMF522Buf, 4, ucComMF522Buf, & ulLen );

    if ( ( cStatus != MI_OK ) || ( ulLen != 4 ) || ( ( ucComMF522Buf [ 0 ] & 0x0F ) != 0x0A ) )
      cStatus = MI_ERR;   
        
    if ( cStatus == MI_OK )
    {
			//memcpy(ucComMF522Buf, pData, 16);
      for ( uc = 0; uc < 16; uc ++ )
			  ucComMF522Buf [ uc ] = * ( pData + uc );  
			
      CalulateCRC ( ucComMF522Buf, 16, & ucComMF522Buf [ 16 ] );

      cStatus = PcdComMF522 ( PCD_TRANSCEIVE, ucComMF522Buf, 18, ucComMF522Buf, & ulLen );
			
			if ( ( cStatus != MI_OK ) || ( ulLen != 4 ) || ( ( ucComMF522Buf [ 0 ] & 0x0F ) != 0x0A ) )
        cStatus = MI_ERR;   
			
    } 
		
		
    return cStatus;
		
		
}


/*
 * PcdRead
 *   ȡM1һ
 *   u8 ucAddrַ
 *         pDataݣ16ֽ
 *   : ״ֵ̬
 *         = MI_OKɹ
 *   ⲿ
 */
char PcdRead ( u8 ucAddr, u8 * pData )
{
    char cStatus;
	  u8 uc, ucComMF522Buf [ MAXRLEN ]; 
    u32 ulLen;
    

    ucComMF522Buf [ 0 ] = PICC_READ;
    ucComMF522Buf [ 1 ] = ucAddr;
	
    CalulateCRC ( ucComMF522Buf, 2, & ucComMF522Buf [ 2 ] );
   
    cStatus = PcdComMF522 ( PCD_TRANSCEIVE, ucComMF522Buf, 4, ucComMF522Buf, & ulLen );
	
    if ( ( cStatus == MI_OK ) && ( ulLen == 0x90 ) )
    {
			for ( uc = 0; uc < 16; uc ++ )
        * ( pData + uc ) = ucComMF522Buf [ uc ];   
    }
		
    else
      cStatus = MI_ERR;   
    
		
    return cStatus;
		
		
}


/*
 * PcdHalt
 *   Ƭ״̬
 *   
 *   : ״ֵ̬
 *         = MI_OKɹ
 *   ⲿ
 */
char PcdHalt( void )
{
	u8 ucComMF522Buf [ MAXRLEN ]; 
	u32  ulLen;
  

  ucComMF522Buf [ 0 ] = PICC_HALT;
  ucComMF522Buf [ 1 ] = 0;
	
  CalulateCRC ( ucComMF522Buf, 2, & ucComMF522Buf [ 2 ] );
 	PcdComMF522 ( PCD_TRANSCEIVE, ucComMF522Buf, 4, ucComMF522Buf, & ulLen );

  return MI_OK;
	
}


void IC_CMT ( u8 * UID, u8 * KEY, u8 RW, u8 * Dat )
{
  u8 ucArray_ID [ 4 ] = { 0 };//ȺICͺUID(ICк)
  
	
  PcdRequest ( 0x52, ucArray_ID );//Ѱ

  PcdAnticoll ( ucArray_ID );//ײ
  
  PcdSelect ( UID );//ѡ
  
  PcdAuthState ( 0x60, 0x10, KEY, UID );//У
	

	if ( RW )//дѡ1Ƕ0д
    PcdRead ( 0x10, Dat );
   
   else 
     PcdWrite ( 0x10, Dat );
   
	 
   PcdHalt ();
	  
}
